ImprovedProductionDistribution = {}
ImprovedProductionDistribution.debug = false

function ImprovedProductionDistribution:distributeGoods()
    if ImprovedProductionDistribution.debug then
        print("---ImprovedProductionDistribution: Running for hour  " ..tostring(g_currentMission.environment.currentHour))
    end
    if self.isServer then
		for _, farmTable in pairs(self.farmIds) do
			if farmTable.productionPoints ~= nil then
				for i = 1, #farmTable.productionPoints do
					local distributingProdPoint = farmTable.productionPoints[i]
                    if ImprovedProductionDistribution.debug then
                        print("---ImprovedProductionDistribution: Checking Distribution from " .. distributingProdPoint:getName())
                    end
					for fillTypeIdToDistribute in pairs(distributingProdPoint.outputFillTypeIdsAutoDeliver) do
						local amountToDistribute = distributingProdPoint.storage:getFillLevel(fillTypeIdToDistribute)
						if amountToDistribute > 0 then
                            if ImprovedProductionDistribution.debug then
                                print("---ImprovedProductionDistribution: Distributing " .. tostring(amountToDistribute) .. "of " .. g_fillTypeManager:getFillTypeNameByIndex(fillTypeIdToDistribute))
                            end

							local prodPointsInDemand = farmTable.inputTypeToProductionPoints[fillTypeIdToDistribute] or {}
							local totalFreeCapacity = 0
							for n = 1, #prodPointsInDemand do
                                local prodPointInDemand = prodPointsInDemand[n]
                                -- if ImprovedProductionDistribution.debug then
                                --     print("---ImprovedProductionDistribution: Checking Distribution to " .. prodPointInDemand:getName())
                                -- end
                                if prodPointInDemand == distributingProdPoint then
                                    -- if ImprovedProductionDistribution.debug then
                                    --     print("---ImprovedProductionDistribution: skipping capacity to itself " .. tostring(prodPointInDemand:getName()))
                                    -- end
                                    continue
                                end
                                local filltypeRequiredAtProdPoint = false
                                -- if ImprovedProductionDistribution.debug then
                                --     print("---ImprovedProductionDistribution: " .. tostring(prodPointInDemand:getName()) .. " has " .. tostring(#prodPointInDemand.activeProductions) .. " active productions")
                                -- end
                                for j = 1, #prodPointInDemand.activeProductions do
                                    local activeProduction = prodPointInDemand.activeProductions[j]
                                    for k = 1, #activeProduction.inputs do
                                        if activeProduction.inputs[k].type == fillTypeIdToDistribute then
                                            filltypeRequiredAtProdPoint = true
                                            -- if ImprovedProductionDistribution.debug then
                                            --     print(string.format("---ImprovedProductionDistribution: Production '%s' needs '%s'", activeProduction.name, g_fillTypeManager:getFillTypeNameByIndex(activeProduction.inputs[k].type)))
                                            -- end
                                        end
                                    end
                                end
                                if filltypeRequiredAtProdPoint then
                                    -- if ImprovedProductionDistribution.debug then
                                    --     print("---ImprovedProductionDistribution: adding capacity at " .. tostring(prodPointInDemand:getName()))
                                    -- end
								    totalFreeCapacity = totalFreeCapacity + prodPointsInDemand[n].storage:getFreeCapacity(fillTypeIdToDistribute, true)
                                else
                                    -- if ImprovedProductionDistribution.debug then
                                    --     print("---ImprovedProductionDistribution: skipping capacity at " .. tostring(prodPointInDemand:getName()))
                                    -- end
                                end
							end
							if totalFreeCapacity > 0 then
								for n = 1, #prodPointsInDemand do
									local prodPointInDemand = prodPointsInDemand[n]
                                    if prodPointInDemand == distributingProdPoint then
                                        -- if ImprovedProductionDistribution.debug then
                                        --     print("---ImprovedProductionDistribution: Dont distribute to myself " .. tostring(prodPointInDemand:getName()))
                                        -- end
                                        continue
                                    end
    
                                    local filltypeRequiredAtProdPoint = false
                                    for j = 1, #prodPointInDemand.activeProductions do
                                        local activeProduction = prodPointInDemand.activeProductions[j]
                                        for k = 1, #activeProduction.inputs do
                                            if activeProduction.inputs[k].type == fillTypeIdToDistribute then
                                                filltypeRequiredAtProdPoint = true
                                            end
                                        end
                                    end
    
                                    if filltypeRequiredAtProdPoint then
                                        local maxAmountToReceive = prodPointInDemand.storage:getFreeCapacity(fillTypeIdToDistribute, true)
                                        if maxAmountToReceive > 0 then
                                            local amountToTransfer = math.min(maxAmountToReceive, amountToDistribute * (maxAmountToReceive / totalFreeCapacity))
                                            local transferCosts = amountToTransfer * calcDistanceFrom(distributingProdPoint.owningPlaceable.rootNode, prodPointInDemand.owningPlaceable.rootNode) * ProductionPoint.DIRECT_DELIVERY_PRICE
                                            g_currentMission:addMoney(-transferCosts, prodPointInDemand.ownerFarmId, MoneyType.PRODUCTION_COSTS, true)
                                            local amountInStockBeforeDest = prodPointInDemand.storage:getFillLevel(fillTypeIdToDistribute)
                                            local amountInStockBeforeSource = distributingProdPoint.storage:getFillLevel(fillTypeIdToDistribute)
                                            local setDestTo = prodPointInDemand.storage:getFillLevel(fillTypeIdToDistribute) + amountToTransfer
                                            local setSourceTo = distributingProdPoint.storage:getFillLevel(fillTypeIdToDistribute) - amountToTransfer
                                            if setSourceTo < 0 then
                                                setSourceTo = 0
                                            end
                                            prodPointInDemand.storage:setFillLevel(setDestTo, fillTypeIdToDistribute)
                                            distributingProdPoint.storage:setFillLevel(setSourceTo, fillTypeIdToDistribute)
                                            if ImprovedProductionDistribution.debug then
                                                local amountInStockDest = prodPointInDemand.storage:getFillLevel(fillTypeIdToDistribute)
                                                local amountInStockSource = distributingProdPoint.storage:getFillLevel(fillTypeIdToDistribute)
                                                print("---ImprovedProductionDistribution: sent ".. tostring(amountToTransfer) .. " of " .. g_fillTypeManager:getFillTypeNameByIndex(fillTypeIdToDistribute) .. " to " .. tostring(prodPointInDemand:getName()) ..  " from " ..tostring(distributingProdPoint:getName()).. ". Stock Level at Destination now "..tostring(amountInStockDest) .. "(" .. tostring(amountInStockBeforeDest).. ")".. ". Stock Level at Source now "..tostring(amountInStockSource) .. "(" .. tostring(amountInStockBeforeSource).. ")")
                                            end
                                        end
									end
								end
							end
						end
					end
				end
			end
		end
	end
end 

ProductionChainManager.distributeGoods = Utils.overwrittenFunction(ProductionChainManager.distributeGoods, ImprovedProductionDistribution.distributeGoods)
if ImprovedProductionDistribution.debug then
    print("ImprovedProductionDistribution: ProductionChain Distribution System overwritten")
end 
