-- author: DD ModPassion
-- copyright (C): DD ModPassion, All Rights Reserved
-- version: Farming Simulator 25
WoodLoader = {}
local modName = g_currentModName
function WoodLoader.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(FillUnit, specializations)
end
function WoodLoader.initSpecialization()
	local schema = Vehicle.xmlSchema
	schema:setXMLSpecializationType("WoodLoader")
	WoodLoader.registerXMLPaths(schema, "vehicle.woodContainer")
	schema:setXMLSpecializationType()
end
function WoodLoader.registerXMLPaths(schema, baseKey)
	schema:register(XMLValueType.INT, baseKey .. "#fillUnitIndex", "Index of fill unit", 1)
	schema:register(XMLValueType.NODE_INDEX, baseKey .. "#triggerNode", "Tree trigger node")
end
function WoodLoader.registerFunctions(vehicleType)
    if vehicleType.getPalletUnloadTriggerExtraSellPrice == nil
    and WoodLoader.getPalletUnloadTriggerExtraSellPrice == nil
    then
        SpecializationUtil.registerFunction(vehicleType, "getPalletUnloadTriggerExtraSellPrice", WoodLoader.getPalletUnloadTriggerExtraSellPrice)
    end
	SpecializationUtil.registerFunction(vehicleType, "onWoodLoaderTriggerCallback", WoodLoader.onWoodLoaderTriggerCallback)
end
function WoodLoader.registerEventListeners(vehicleType)
	SpecializationUtil.registerEventListener(vehicleType, "onLoad", WoodLoader)
	SpecializationUtil.registerEventListener(vehicleType, "onDelete", WoodLoader)
end
function WoodLoader:onLoad(savegame)
	local spec = self.spec_fillUnit
	local configKey = string.format("vehicle.woodContainer")
	spec.fillUnitIndex = self.xmlFile:getValue(configKey .. "#fillUnitIndex", 1)
	spec.triggerNode = self.xmlFile:getValue(configKey .. "#triggerNode", nil, self.components, self.i3dMappings)
	if self.isServer
    and spec.triggerNode ~= nil
    then
		addTrigger(spec.triggerNode, "onWoodLoaderTriggerCallback", self)
	end
end
function WoodLoader:onDelete()
	local spec = self.spec_fillUnit
	if spec.triggerNode ~= nil
    then
		removeTrigger(spec.triggerNode)
	end
end
function WoodLoader:getPalletUnloadTriggerExtraSellPrice()
	return self:getPrice()
end
function WoodLoader:onWoodLoaderTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
	if otherId ~= 0
    then
		local splitType = g_splitShapeManager:getSplitTypeByIndex(getSplitType(otherId))
		if splitType ~= nil
        and splitType.pricePerLiter > 0
        then
			if not splitType.name:contains("TRANSPORT")
            then
                local spec = self.spec_fillUnit
				local liter, qualityScale, length = WoodUnloadTrigger:calculateWoodBaseValue(otherId)
				if liter > 0
                and qualityScale > 0
                and self:getFillUnitFreeCapacity(spec.fillUnitIndex) > 0
                then
					self:addFillUnitFillLevel(self:getOwnerFarmId(), spec.fillUnitIndex, liter, FillType.WOOD, ToolType.UNDEFINED, nil)
					delete(otherId)
				end
			end
		end
	end
end